import { runner, tween, tweenFuncs } from './tween.js';

const svg = document.querySelector('svg');
const circle = document.querySelector('circle');
const select = document.querySelector('select');

let { x, y } = circle.getBoundingClientRect();

let tweenFunc = tweenFuncs.linear;
let stopTweens = () => {};

svg.addEventListener('click', e => {
  stopTweens();

  const tweenX = tween({ tweenFunc, start: x, dest: e.clientX });
  const stopTweenX = runner({ 
    tween: tweenX, 
    duration: 250, 
    func: value => {
      x = value;
      circle.style.setProperty('cx', `${x}px`);
    } 
  });
  
  const tweenY = tween({ tweenFunc, start: y, dest: e.clientY });
  const stopTweenY = runner({ 
    tween: tweenY, 
    duration: 250, 
    func: value => {
      y = value;
      circle.style.setProperty('cy', `${y}px`);
    } 
  });

  stopTweens = () => {
    stopTweenX();
    stopTweenY();
  };
});

select.addEventListener('change', e => {
  tweenFunc = tweenFuncs[e.target.value];
})