export function applyPercentage(percentage, min, max) {
  // remove min and add it back after percentage is applied
  const newMax = max - min;
  const value = percentage * newMax;

  return value + min;
}

// loops for an unknown amount of times during a specific duration
export function loopFor(duration, func) {
  const startTime = performance.now();
  const stopTime = startTime + duration;

  let shouldStop = false;

  function animate(currentTime) {
    func(currentTime);

    if (currentTime >= stopTime || shouldStop) return;

    requestAnimationFrame(animate);
  }
  requestAnimationFrame(animate);

  return () => shouldStop = true;
}

export function tween({ tweenFunc, start, dest }) {
  return (timePerc) => {
    // transform the time percentage via tween func
    const percentage = tweenFunc(timePerc);

    // get the appropriate value via percentage
    return applyPercentage(percentage, start, dest);
  }
}

export function runner({ tween, func, duration }) {
  const startTime = performance.now();
  // return the stopping function
  return loopFor(duration, currentTime => {
    // get how far we are into the goal
    const timePerc = (currentTime - startTime) / duration;

    // retrieve value using tween
    const currentValue = tween(timePerc);
    
    // pass value to callback
    func(currentValue);
  });
}

// visual representation: https://okku.dev/easings/
export const tweenFuncs = {
  linear: t => t,
  quadIn: t => t**2,
  cubicIn: t => t**3,
  quartIn: t => t**4,

  stagger: t => Math.floor(t * 10) / 10,

  quadOut: t => t * (2 - t),

  quadInOut: t => {
    const double = 2*t;
    if (double < 1) {
      return 0.5 * double**2;
    }

    const small = double - 1;
    return -0.5 * (small * (small - 2) - 1);
  }
};